/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.ClientHistory;
import com.tp_link.eap.domain.eap.StatCurrentAp;
import com.tp_link.eap.domain.eap.StatCurrentClient;
import com.tp_link.eap.domain.eap.StatCurrentSsid;
import com.tp_link.eap.domain.eap.StatLifeClient;
import com.tp_link.eap.domain.eap.StatRADaily;
import com.tp_link.eap.domain.eap.StatRAHourly;
import com.tp_link.eap.domain.eap.bean.SsidTotalStat;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.mesh.service.a;
import com.tp_link.eap.monitor.monitor.model.StatLifeClientModel;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.monitor.monitor.repo.ClientHistoryRepository;
import com.tp_link.eap.monitor.monitor.repo.ClientRepository;
import com.tp_link.eap.monitor.monitor.repo.StatCurApRepository;
import com.tp_link.eap.monitor.monitor.repo.StatCurClientRepository;
import com.tp_link.eap.monitor.monitor.repo.StatCurSsidRepository;
import com.tp_link.eap.monitor.monitor.repo.StatLifeClientRepository;
import com.tp_link.eap.monitor.monitor.repo.StatRADailyRepository;
import com.tp_link.eap.monitor.monitor.repo.StatRAHourlyRepository;
import com.tp_link.eap.monitor.monitor.service.b;
import com.tp_link.eap.monitor.monitor.service.c;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.impl.StatService$ActiveStatus;
import com.tp_link.eap.monitor.monitor.service.impl.StatService$RAStat;
import com.tp_link.eap.monitor.monitor.service.impl.StatService$SortByClientNum;
import com.tp_link.eap.monitor.monitor.service.impl.StatService$SortByTraffic;
import com.tp_link.eap.monitor.monitor.service.impl.StatService$TopNTotalStat;
import com.tp_link.eap.monitor.monitor.service.j;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="statService")
public class StatService
extends com.tp_link.eap.i.a.a<StatLifeClient>
implements j {
    @Autowired
    private StatCurApRepository a;
    @Autowired
    private StatCurClientRepository b;
    @Autowired
    private StatCurSsidRepository c;
    @Autowired
    private StatLifeClientRepository d;
    @Autowired
    private StatRADailyRepository e;
    @Autowired
    private StatRAHourlyRepository f;
    @Autowired
    private ApRepository g;
    @Autowired
    private ClientRepository h;
    @Autowired
    private ClientHistoryRepository i;
    @Autowired
    private c j;
    @Autowired
    private d k;
    @Autowired
    private a l;
    @Autowired
    private b m;
    @Autowired
    private MongoTemplate n;
    private static final Logger o = LoggerFactory.getLogger(StatService.class);

    @Override
    public Ap getMostActiveAp() {
        StatCurrentAp statCurrentAp = this.a.getTop("totalTraffic");
        if (statCurrentAp == null) {
            return null;
        }
        Ap ap = this.g.findByMac(statCurrentAp.getApMac());
        if (ap == null) {
            return null;
        }
        ap.setSca(statCurrentAp);
        return ap;
    }

    @Override
    public OperationResponse getMostActiveAp(ControlType controlType, JSONObject reqObj) {
        Ap ap = this.getMostActiveAp();
        Client client = this.getMostActiveClient();
        Client client2 = this.getAllTimeTopClient();
        StatService$ActiveStatus statService$ActiveStatus = new StatService$ActiveStatus();
        statService$ActiveStatus.setMostActiveApSubInfo(ap);
        statService$ActiveStatus.setMostActiveClientSubInfo(client);
        statService$ActiveStatus.setAlltimeMostActiveClientSubInfo(client2);
        return new OperationResponse(ResErrorCode.a, (Object)statService$ActiveStatus);
    }

    @Override
    public Client getMostActiveClient() {
        StatCurrentClient statCurrentClient = this.b.getTop();
        if (statCurrentClient == null) {
            return null;
        }
        Client client = this.h.findByMacAndSite(statCurrentClient.getMac(), com.tp_link.eap.d.b.a());
        if (client == null) {
            return null;
        }
        client.setScc(statCurrentClient);
        return client;
    }

    @Override
    public Client getAllTimeTopClient() {
        StatLifeClient statLifeClient = this.d.getTop();
        if (statLifeClient == null) {
            return null;
        }
        Client client = this.h.findByMacAndSite(statLifeClient.getMac(), com.tp_link.eap.d.b.a());
        if (client == null) {
            return null;
        }
        client.setSlc(statLifeClient);
        return client;
    }

    @Override
    public List<SsidTotalStat> getSsidTotalStats(String site) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ssid");
        List<StatCurrentSsid> list = this.c.getListOrderBy(arrayList, site);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<SsidTotalStat> arrayList2 = new ArrayList<SsidTotalStat>();
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        String string = null;
        while (!list.isEmpty()) {
            StatCurrentSsid statCurrentSsid = list.remove(0);
            if (string != null && !statCurrentSsid.getSsid().equals(string)) {
                arrayList2.add(new SsidTotalStat(string, l2, l3, (long)n2));
                string = statCurrentSsid.getSsid();
                n2 = statCurrentSsid.getClientNum();
                l2 = statCurrentSsid.getDownload();
                l3 = statCurrentSsid.getUpload();
                continue;
            }
            string = statCurrentSsid.getSsid();
            n2 += statCurrentSsid.getClientNum();
            l2 += statCurrentSsid.getDownload().longValue();
            l3 += statCurrentSsid.getUpload().longValue();
        }
        arrayList2.add(new SsidTotalStat(string, l2, l3, (long)n2));
        for (SsidTotalStat ssidTotalStat : arrayList2) {
            ssidTotalStat.setTotalClient(this.k.countSsidActiveClients(ssidTotalStat.getSsid()));
        }
        return arrayList2;
    }

    @Override
    public List<StatRAHourly> getRAHourlyStats(long startTime, long endTime) {
        return this.f.get(com.tp_link.eap.d.b.a(), startTime, endTime);
    }

    @Override
    public List<StatRADaily> getRADailyStats(long startTime, long endTime) {
        return this.e.get(com.tp_link.eap.d.b.a(), startTime, endTime);
    }

    @Override
    public boolean refreshCurrentApStat(StatCurrentAp sca, int clientNum) {
        if (sca == null) {
            return false;
        }
        o.debug("clientNum of ap {} is {}", (Object)sca.getApMac(), (Object)clientNum);
        sca.setClientNum(clientNum);
        StatCurrentAp statCurrentAp = this.a.findByApMac(sca.getApMac());
        if (statCurrentAp == null) {
            sca.setTotalTraffic(Long.valueOf(sca.getDownload() + sca.getUpload()));
            this.a.save(sca);
        } else {
            sca.setId(statCurrentAp.getId());
            sca.setTotalTraffic(Long.valueOf(sca.getDownload() + sca.getUpload()));
            this.a.save(sca);
            if (sca.getDownload() < statCurrentAp.getDownload()) {
                com.tp_link.eap.monitor.monitor.cache.a.a(sca.getApMac(), statCurrentAp.getTotalTraffic());
            }
        }
        return true;
    }

    @Override
    public boolean refreshCurrentClientStat(List<StatCurrentClient> sccs) {
        block6: {
            block7: {
                StatCurrentClient statCurrentClient;
                int n2;
                List list;
                block5: {
                    list = com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll());
                    if (sccs != null && !sccs.isEmpty()) break block5;
                    if (list == null || list.isEmpty()) break block6;
                    this.b.delete(list);
                    this.a(list);
                    break block6;
                }
                if (list == null || list.isEmpty()) break block7;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    int n3;
                    statCurrentClient = (StatCurrentClient)list.get(n2);
                    for (n3 = 0; n3 < sccs.size(); ++n3) {
                        StatCurrentClient statCurrentClient2 = sccs.get(n3);
                        if (!statCurrentClient2.getMac().equals(statCurrentClient.getMac())) continue;
                        statCurrentClient.setDuration(statCurrentClient2.getDuration());
                        statCurrentClient.setDownload(statCurrentClient2.getDownload());
                        statCurrentClient.setUpload(statCurrentClient2.getUpload());
                        statCurrentClient.setTotalTraffic(statCurrentClient2.getDownload() + statCurrentClient2.getUpload());
                        this.b.save(statCurrentClient);
                        break;
                    }
                    if (n3 >= sccs.size()) {
                        this.b.delete(statCurrentClient);
                        this.a(statCurrentClient);
                        continue;
                    }
                    sccs.remove(n3);
                }
                if (sccs.isEmpty()) break block6;
                for (n2 = 0; n2 < sccs.size(); ++n2) {
                    statCurrentClient = sccs.get(n2);
                    statCurrentClient.setTotalTraffic(statCurrentClient.getDownload() + statCurrentClient.getUpload());
                    this.b.save(statCurrentClient);
                }
                break block6;
            }
            for (int i2 = 0; i2 < sccs.size(); ++i2) {
                StatCurrentClient statCurrentClient = sccs.get(i2);
                statCurrentClient.setTotalTraffic(statCurrentClient.getDownload() + statCurrentClient.getUpload());
                this.b.save(statCurrentClient);
            }
        }
        return true;
    }

    @Override
    public boolean refreshCurrentSsidStat(String apMac, List<StatCurrentSsid> scss) {
        if (apMac == null) {
            return false;
        }
        List<StatCurrentSsid> list = this.c.findByApMac(apMac);
        if (list != null) {
            this.c.delete(list);
        }
        if (scss != null && !scss.isEmpty()) {
            for (int i2 = 0; i2 < scss.size(); ++i2) {
                StatCurrentSsid statCurrentSsid = scss.get(i2);
                statCurrentSsid.setApMac(apMac);
            }
            this.c.save(scss);
        }
        return true;
    }

    private void a(StatCurrentClient statCurrentClient) {
        if (statCurrentClient == null) {
            return;
        }
        Client client = this.h.findByMacAndSite(statCurrentClient.getMac(), statCurrentClient.getSite());
        if (client == null) {
            o.warn("Failed to find client {} of site {}, stop refreshing StatLifeClient", (Object)statCurrentClient.getMac(), (Object)statCurrentClient.getSite());
            return;
        }
        boolean bl = false;
        StatLifeClient statLifeClient = this.d.findByMacAndSite(statCurrentClient.getMac(), statCurrentClient.getSite());
        if (statLifeClient == null) {
            statLifeClient = new StatLifeClient(statCurrentClient, client.getLastSeen().longValue());
        } else {
            bl = true;
            statLifeClient.setDownload(Long.valueOf(statLifeClient.getDownload() + statCurrentClient.getDownload()));
            statLifeClient.setUpload(Long.valueOf(statLifeClient.getUpload() + statCurrentClient.getUpload()));
            statLifeClient.setDuration(Long.valueOf(statLifeClient.getDuration() + statCurrentClient.getDuration()));
            statLifeClient.setTotalTraffic(Long.valueOf(statLifeClient.getTotalTraffic() + statCurrentClient.getTotalTraffic()));
            statLifeClient.setHostname(statCurrentClient.getHostname());
            statLifeClient.setLastSeen(client.getLastSeen().longValue());
        }
        this.a(client, statLifeClient);
        statLifeClient.setBlock(client.isBlock());
        statLifeClient.setGuest(client.isGuest());
        statLifeClient.setActive(client.isActive());
        statLifeClient.setClientRateLimitSetting(client.getClientRateLimitSetting());
        this.d.save(statLifeClient);
        if (bl) {
            StatLifeClient statLifeClient2 = (StatLifeClient)this.d.findOne((Serializable)((Object)statLifeClient.getId()));
            if (!statLifeClient.getDuration().equals(statLifeClient2.getDuration())) {
                this.d.save(statLifeClient);
            }
        }
    }

    private void a(List<StatCurrentClient> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.a(list.get(i2));
        }
    }

    @Override
    public StatCurrentAp getStatCurrentApByMac(String apMac) {
        return this.a.findByApMac(apMac);
    }

    public List<StatLifeClient> getList(QueryPage queryPage) {
        return this.d.getByFilters(queryPage, null, null, null);
    }

    public List<StatLifeClient> getList(QueryPage queryPage, QuerySort querySort) {
        return this.d.getByFilters(queryPage, querySort, null, null);
    }

    public List<StatLifeClient> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.d.getByFilters(queryPage, null, filters, searchFilters);
    }

    public List<StatLifeClient> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.d.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.d.countByFilters(filters, searchFilters);
    }

    @Override
    public List<StatCurrentAp> getTopUsage(int topN, String key) {
        if (topN <= 0) {
            return null;
        }
        List<StatCurrentAp> list = this.a.getTop(topN, key);
        if (!CollectionUtils.isEmpty(list)) {
            StatService$TopNTotalStat statService$TopNTotalStat = this.b(list);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                StatCurrentAp statCurrentAp = list.get(i2);
                statCurrentAp.setClientPercent((double)statCurrentAp.getClientNum() / (double)statService$TopNTotalStat.getTotalClient());
                statCurrentAp.setTrafficPercent((double)statCurrentAp.getTotalTraffic().longValue() / (double)statService$TopNTotalStat.getTotalTraffic());
            }
        }
        return list;
    }

    @Override
    public OperationResponse getTopUsage(ControlType controlType, JSONObject reqObj) {
        int n2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            o.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        int n3 = 10;
        String string = "clientNum";
        List<StatCurrentAp> list = this.getTopUsage(n3, string);
        if (list == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            String string2 = list.get(n2).getApMac();
            list.get(n2).setApName(this.m.getApDetail(string2).getName());
        }
        n2 = queryData.getCurrentPage();
        int n4 = queryData.getCurrentPageSize();
        Object object = new ArrayList();
        list = this.c(list);
        object = n2 == 1 ? (list.size() > n4 ? new ArrayList<StatCurrentAp>(list.subList(0, queryData.getCurrentPageSize())) : list) : (list.size() <= n4 ? null : new ArrayList<StatCurrentAp>(list.subList(queryData.getCurrentPageSize(), list.size())));
        grid.setTotalRows((long)list.size());
        grid.setData(object);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getRecentActivityStatistics(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            o.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        long l2 = StatService.a(jSONObject.optString("calendar"));
        String string = jSONObject.optString("mode");
        if (string == null || !string.equals("hours") && !string.equals("days")) {
            return com.tp_link.eap.util.e.aZ;
        }
        HashMap hashMap = new HashMap();
        TreeSet<StatService$RAStat> treeSet = new TreeSet<StatService$RAStat>();
        TreeSet<StatService$RAStat> treeSet2 = new TreeSet<StatService$RAStat>();
        if (string.equals("hours")) {
            long l3 = com.tp_link.eap.util.c.a.b((long)l2);
            List<StatRAHourly> list = this.getRAHourlyStats(l3, l2);
            if (list != null) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    StatRAHourly statRAHourly = list.get(i2);
                    treeSet.add(new StatService$RAStat(statRAHourly.getDaytime(), com.tp_link.eap.util.e.a((long)statRAHourly.getTraffic())));
                    treeSet2.add(new StatService$RAStat(statRAHourly.getDaytime(), statRAHourly.getMaxClients()));
                }
            }
            long l4 = 3600000L;
            for (long i3 = 0L; i3 <= 24L; ++i3) {
                treeSet.add(new StatService$RAStat(l3 + i3 * l4, 0));
                treeSet2.add(new StatService$RAStat(l3 + i3 * l4, 0));
            }
        } else {
            long l5 = com.tp_link.eap.util.c.a.d((long)com.tp_link.eap.util.c.a.c((long)l2));
            List<StatRADaily> list = this.getRADailyStats(l5, l2);
            if (list != null) {
                for (int i4 = 0; i4 < list.size(); ++i4) {
                    StatRADaily statRADaily = list.get(i4);
                    if (!this.a(l5, statRADaily.getDaytime())) continue;
                    treeSet.add(new StatService$RAStat(statRADaily.getDaytime(), com.tp_link.eap.util.e.a((long)statRADaily.getTraffic())));
                    treeSet2.add(new StatService$RAStat(statRADaily.getDaytime(), statRADaily.getMaxClients()));
                }
            }
            long l6 = 86400000L;
            for (long i5 = 0L; i5 <= 30L; ++i5) {
                treeSet.add(new StatService$RAStat(l5 + i5 * l6, 0));
                treeSet2.add(new StatService$RAStat(l5 + i5 * l6, 0));
            }
        }
        hashMap.put("traffic", new ArrayList(treeSet));
        hashMap.put("clients", new ArrayList(treeSet2));
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getStatisticsCalendar(ControlType controlType, JSONObject reqObj) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long l2 = System.currentTimeMillis();
        long l3 = com.tp_link.eap.util.c.a.b((long)l2);
        long l4 = l3 + 86400000L;
        long l5 = com.tp_link.eap.util.c.a.d((long)com.tp_link.eap.util.c.a.c((long)l2));
        long l6 = l5 + 2592000000L;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"hourlyStartTime", (Object)simpleDateFormat.format(new Date(l3)));
        jSONObject.put((Object)"hourlyEndTime", (Object)simpleDateFormat.format(new Date(l4)));
        jSONObject.put((Object)"dailyStartTime", (Object)simpleDateFormat.format(new Date(l5)));
        jSONObject.put((Object)"dailyEndTime", (Object)simpleDateFormat.format(new Date(l6)));
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public boolean deleteSca(String apMac) {
        StatCurrentAp statCurrentAp = this.a.findByApMac(apMac);
        if (statCurrentAp != null) {
            this.a.delete(statCurrentAp);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteScs(String apMac) {
        List<StatCurrentSsid> list;
        if (apMac != null && !CollectionUtils.isEmpty(list = this.c.findByApMac(apMac))) {
            this.c.delete(list);
            return true;
        }
        return false;
    }

    private StatService$TopNTotalStat b(List<StatCurrentAp> list) {
        int n2 = 0;
        long l2 = 0L;
        for (StatCurrentAp statCurrentAp : list) {
            n2 += statCurrentAp.getClientNum();
            l2 += statCurrentAp.getTotalTraffic().longValue();
        }
        n2 = n2 == 0 ? Integer.MAX_VALUE : n2;
        l2 = l2 == 0L ? Long.MAX_VALUE : l2;
        return new StatService$TopNTotalStat(n2, l2);
    }

    @Override
    public boolean refreshCurrentClientStat(Client client) {
        if (client == null) {
            return false;
        }
        StatCurrentClient statCurrentClient = this.b.findByMac(client.getMac());
        if (statCurrentClient == null) {
            statCurrentClient = new StatCurrentClient();
        }
        statCurrentClient.setApMac(client.getApMac());
        statCurrentClient.setMac(client.getMac());
        statCurrentClient.setDuration(client.getDuration());
        statCurrentClient.setDownload(client.getDownload());
        statCurrentClient.setUpload(client.getUpload());
        statCurrentClient.setTotalTraffic(client.getDownload() + client.getUpload());
        statCurrentClient.setSite(client.getSite());
        statCurrentClient.setHostname(client.getName());
        this.b.save(statCurrentClient);
        this.refreshLifeClientStatByClientMac(client.getMac(), client.getSite());
        return true;
    }

    @Override
    public void deleteCurrentClientStat(String clientMac) {
        StatCurrentClient statCurrentClient = this.b.findByMac(clientMac);
        if (statCurrentClient != null) {
            this.b.delete(statCurrentClient);
            this.a(statCurrentClient);
        }
    }

    @Override
    public StatCurrentClient getScc(String clientMac) {
        return this.b.findByMac(clientMac);
    }

    @Override
    public void deleteBySite() {
        List<StatRADaily> list;
        String string = com.tp_link.eap.d.b.a();
        List<StatRAHourly> list2 = this.f.findBySite(string);
        if (!CollectionUtils.isEmpty(list2)) {
            this.f.delete(list2);
        }
        if (!CollectionUtils.isEmpty(list = this.e.findBySite(string))) {
            this.e.delete(list);
        }
    }

    @Override
    public void refreshLifeClientStatByClientMac(String clientMac, String site) {
        Client client;
        StatLifeClient statLifeClient = this.d.findByMacAndSite(clientMac, site);
        if (statLifeClient != null && (client = this.h.findByMacAndSite(clientMac, site)) != null) {
            statLifeClient.setBlock(client.isBlock());
            statLifeClient.setGuest(client.isGuest());
            statLifeClient.setActive(client.isActive());
            this.d.save(statLifeClient);
        }
    }

    private void a(Client client, StatLifeClient statLifeClient) {
        if (client != null) {
            com.tp_link.eap.d.b.b((String)client.getSite());
            ClientHistory clientHistory = this.j.getLatestHistory(client.getMac(), client.getSite());
            if (this.a(client, clientHistory)) {
                o.debug("slc : " + statLifeClient);
                o.debug("old client history : " + clientHistory);
                if (statLifeClient != null) {
                    statLifeClient.setLastSeen(client.getLastSeen().longValue());
                    statLifeClient.setDownload(Long.valueOf(statLifeClient.getDownload() - clientHistory.getDownload()));
                    statLifeClient.setUpload(Long.valueOf(statLifeClient.getUpload() - clientHistory.getUpload()));
                    statLifeClient.setTotalTraffic(Long.valueOf(statLifeClient.getDownload() + statLifeClient.getUpload()));
                    statLifeClient.setDuration(Long.valueOf(statLifeClient.getDuration() - clientHistory.getDuration()));
                }
                clientHistory.setDownload(client.getDownload());
                clientHistory.setDuration(client.getDuration());
                clientHistory.setUpload(client.getUpload());
                clientHistory.setLastSeen(client.getLastSeen().longValue());
                this.j.addHistory(clientHistory);
                ClientHistory clientHistory2 = this.j.getClientHistoryById(clientHistory.getId());
                if (clientHistory2 != null && clientHistory2.getDuration() != clientHistory.getDuration()) {
                    this.j.addHistory(clientHistory);
                }
            } else {
                ClientHistory clientHistory3 = new ClientHistory();
                clientHistory3.setClientMac(client.getMac());
                clientHistory3.setDownload(client.getDownload());
                clientHistory3.setUpload(client.getUpload());
                clientHistory3.setDuration(client.getDuration());
                clientHistory3.setLastSeen(client.getLastSeen().longValue());
                clientHistory3.setSite(client.getSite());
                this.j.addHistory(clientHistory3);
            }
        }
    }

    private boolean a(Client client, ClientHistory clientHistory) {
        if (clientHistory == null) {
            return false;
        }
        return client.getDuration() * 1000L > client.getLastSeen() - clientHistory.getLastSeen();
    }

    @Override
    public List<StatLifeClient> getClientLimited(QueryPage page, QuerySort sort, List<QueryFilter> andFilters, List<QueryFilter> orFilters) {
        return this.d.getClientLimited(page, sort, andFilters, orFilters);
    }

    @Override
    public long countClientLimited(List<QueryFilter> andFilters, List<QueryFilter> orFilters) {
        return this.d.countClientLimited(andFilters, orFilters);
    }

    @Override
    public void refreshRateLimit(Client client) {
        StatLifeClient statLifeClient = this.d.findByMacAndSite(client.getMac(), client.getSite());
        if (statLifeClient != null) {
            statLifeClient.setClientRateLimitSetting(client.getClientRateLimitSetting());
            this.d.save(statLifeClient);
        }
    }

    @Override
    public OperationResponse getSsidStats(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            o.warn("Failed to get site for getSsidStats");
            return com.tp_link.eap.util.e.aY;
        }
        List<SsidTotalStat> list = this.getSsidTotalStats(string);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                SsidTotalStat ssidTotalStat = list.get(i2);
                if (ssidTotalStat.getTotalClient() != 0L) continue;
                list.remove(i2);
                --i2;
            }
            if (list.isEmpty()) {
                list = null;
            }
        }
        if (list != null) {
            Collections.sort(list, new StatService$SortByClientNum());
        } else {
            list = new ArrayList<SsidTotalStat>();
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"ssidList", list);
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public OperationResponse getGridClientStats(ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            o.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)com.tp_link.eap.util.a.b.a((Object)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"mac", "hostname"});
        Map map = queryData.getFilters();
        boolean bl = false;
        if (map != null) {
            Object object2;
            Object v = map.get("clientType");
            if (v != null) {
                object2 = (String)v;
                if (((String)object2).equals("Guest")) {
                    grid.initFilters("isGuest", (Object)true, QueryFilter.FilterType.eq);
                } else if (((String)object2).equals("User")) {
                    grid.initFilters("isGuest", (Object)false, QueryFilter.FilterType.eq);
                } else if (((String)object2).equals("Blocked")) {
                    grid.initFilters("isBlock", (Object)true, QueryFilter.FilterType.eq);
                } else if (((String)object2).equals("Rate Limited")) {
                    bl = true;
                }
            }
            if ((v = map.get("lastSeen")) != null) {
                object2 = Long.parseLong(String.valueOf(v));
                object = 0L;
                object = (Long)object2 == 0L ? Long.valueOf(0L) : Long.valueOf(System.currentTimeMillis() - (Long)object2 * 3600000L);
                grid.initFilters("lastSeen", object, QueryFilter.FilterType.gte);
            }
            if ((v = map.get("offline")) != null && ((String)(object2 = (String)v)).equals("Offline")) {
                grid.initFilters("isActive", (Object)false, QueryFilter.FilterType.eq);
            }
        }
        long l2 = 0L;
        object = null;
        if (!bl) {
            l2 = this.count(grid.getFilters(), grid.getSearchFilters());
            grid.setTotalRows(l2);
            object = this.getList(grid);
        } else {
            l2 = this.countClientLimited(grid.getFilters(), grid.getSearchFilters());
            grid.setTotalRows(l2);
            object = this.getClientLimited(grid.getQueryPage(), grid.getQuerySort(), grid.getFilters(), grid.getSearchFilters());
        }
        ArrayList<StatLifeClientModel> arrayList = new ArrayList<StatLifeClientModel>();
        if (!CollectionUtils.isEmpty((Collection)object)) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                StatLifeClient statLifeClient = (StatLifeClient)iterator.next();
                statLifeClient.setBlock(this.k.getClient(statLifeClient.getMac(), com.tp_link.eap.d.b.a()).isBlock());
                arrayList.add(this.a(statLifeClient));
            }
        }
        grid.setData(arrayList);
        grid.setTotalRows(l2);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public void clearStatBeforeTime(long time) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"daytime").lt((Object)time));
        this.n.remove(query, StatRADaily.class);
        this.n.remove(query, StatRAHourly.class);
    }

    @Override
    public List<StatRAHourly> getStatRaHourlyAfterTime(long time) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"daytime").gt((Object)time));
        return this.n.find(query, StatRAHourly.class);
    }

    @Override
    public List<StatRADaily> getStatRaDailyAfterTime(long time) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"daytime").gt((Object)time));
        return this.n.find(query, StatRADaily.class);
    }

    @Override
    public List<StatLifeClient> getStatLifeClientAfterTime(long time) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"lastSeen").gt((Object)time));
        return this.n.find(query, StatLifeClient.class);
    }

    @Override
    public void addStatRaHourly(StatRAHourly raHourly) {
        this.a();
        this.f.save(raHourly);
    }

    @Override
    public void addStatRaDaily(StatRADaily raDaily) {
        this.a();
        this.e.save(raDaily);
    }

    @Override
    public void addStatRaHourly(List<StatRAHourly> raHourlyList) {
        this.f.save(raHourlyList);
        this.a();
    }

    @Override
    public void addStatRaDaily(List<StatRADaily> raDailyList) {
        this.e.save(raDailyList);
        this.a();
    }

    @Override
    public void addStatLifeClient(StatLifeClient statLifeClient) {
        this.d.save(statLifeClient);
        Client client = this.h.findByMacAndSite(statLifeClient.getMac(), statLifeClient.getSite());
        if (null == client) {
            client = new Client();
            client.setMac(statLifeClient.getMac());
            client.setName(statLifeClient.getHostname());
            client.setLastSeen(Long.valueOf(statLifeClient.getLastSeen()));
            client.setSite(statLifeClient.getSite());
            client.setActive(statLifeClient.isActive());
            client.setBlock(statLifeClient.isBlock());
            client.setGuest(statLifeClient.isGuest());
            client.setDuration(statLifeClient.getDuration().longValue());
            client.setUpload(statLifeClient.getUpload().longValue());
            client.setDownload(statLifeClient.getDownload().longValue());
            this.k.refreshClient(client);
        }
    }

    @Override
    public void deleteAll() {
        this.f.deleteAll();
        this.e.deleteAll();
    }

    private List<StatCurrentAp> c(List<StatCurrentAp> list) {
        ArrayList<StatCurrentAp> arrayList = new ArrayList<StatCurrentAp>();
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<StatCurrentAp> arrayList2 = new ArrayList<StatCurrentAp>();
            StatCurrentAp statCurrentAp = list.remove(0);
            arrayList2.add(statCurrentAp);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2).getClientNum() == statCurrentAp.getClientNum()) {
                    arrayList2.add(list.get(i2));
                    continue;
                }
                Collections.sort(arrayList2, new StatService$SortByTraffic());
                arrayList.addAll(arrayList2);
                arrayList2.clear();
                statCurrentAp = list.get(i2);
                arrayList2.add(statCurrentAp);
            }
            if (!arrayList2.isEmpty()) {
                Collections.sort(arrayList2, new StatService$SortByTraffic());
                arrayList.addAll(arrayList2);
            }
            return arrayList;
        }
        return arrayList;
    }

    private StatLifeClientModel a(StatLifeClient statLifeClient) {
        if (statLifeClient == null) {
            return null;
        }
        StatLifeClientModel statLifeClientModel = new StatLifeClientModel();
        BeanUtils.copyProperties((Object)statLifeClient, (Object)((Object)statLifeClientModel));
        if (statLifeClient.isActive()) {
            Client client = this.k.getClient(statLifeClient.getMac(), com.tp_link.eap.d.b.a());
            Integer n2 = null;
            if (client != null) {
                n2 = client.getSnr();
            }
            statLifeClientModel.setSignalLevel(n2 == null ? 0 : com.tp_link.eap.util.l.a((int)n2));
        } else {
            statLifeClientModel.setSignalLevel(0);
        }
        statLifeClientModel.setClientType(com.tp_link.eap.util.l.i((String)statLifeClient.getHostname()));
        return statLifeClientModel;
    }

    private void a() {
        if (com.tp_link.eap.util.l.b()) {
            return;
        }
        long l2 = this.e.count();
        long l3 = this.f.count();
        while (l2 + l3 >= 101000L) {
            o.info("stat ra reached maximum, daily {}, hourly {}", (Object)l2, (Object)l3);
            List<StatRADaily> list = this.e.getAndClearOldest(40);
            for (StatRADaily statRADaily : list) {
                int n2 = com.tp_link.eap.util.c.a.a((long)statRADaily.getDaytime());
                long l4 = com.tp_link.eap.util.c.a.a((int)n2);
                long l5 = com.tp_link.eap.util.c.a.b((int)n2);
                this.f.clear(statRADaily.getSite(), l4, l5);
            }
            l2 = this.e.count();
            l3 = this.f.count();
            o.info("after clear num is daily {}, hourly {}", (Object)l2, (Object)l3);
        }
    }

    private boolean a(long l2, long l3) {
        long l4 = 86400000L;
        for (long i2 = 0L; i2 <= 30L; ++i2) {
            if (l2 + i2 * l4 != l3) continue;
            return true;
        }
        return false;
    }

    private static long a(String string) {
        long l2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = simpleDateFormat.parse(string);
            l2 = date.getTime();
        }
        catch (ParseException parseException) {
            o.debug(parseException.toString(), (Throwable)parseException);
            l2 = System.currentTimeMillis();
        }
        return l2;
    }
}

